#pragma once

#include <ymod_httpclient/call.h>
#include <ymod_tvm/module.h>

#include <internal/blackbox/interface.h>

namespace settings::blackbox {

using HttpClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;
using Tvm2ModulePtr = std::shared_ptr<ymod_tvm::tvm2_module>;

class Http : public BlackBoxInterface {
public:
    Http(HttpClientPtr, Tvm2ModulePtr);

    expected<std::string> infoRequest(ContextPtr, const std::string&) const final;

private:
    HttpClientPtr httpClient_;
    Tvm2ModulePtr tvm2Module_;
};

} // namespace settings::blackbox
