#pragma once

#include <internal/blackbox/interface.h>

#include <ymod_httpclient/url_encode.h>

#include <boost/hana/string.hpp>

namespace settings::blackbox {

using namespace boost::hana::literals;

class Impl: public Interface {
public:
    using HttpPtr = std::shared_ptr<BlackBoxInterface>;

    Impl(HttpPtr);

    Impl() = default;

    void init();

    expected<void> isUserExists(ContextPtr, const std::string&,
            const std::string&) const final;
    expected<AccountInfoPtr> getAccountInfo(ContextPtr, const std::string&,
            const std::string&) const final;

private:
    static constexpr auto suidKey = "subscription.suid.2"_s;
    static constexpr auto firstNameKey = "userinfo.firstname.uid"_s;
    static constexpr auto lastNameKey = "userinfo.lastname.uid"_s;
    static constexpr auto firstNameEngKey = "212"_s;
    static constexpr auto lastNameEngKey = "213"_s;

    HttpPtr http_;
};

} // namespace settings::blackbox
