#pragma once

#include <yplatform/module.h>

#include <internal/common/types.h>
#include <internal/blackbox/types.h>
#include <internal/common/context.h>
#include <internal/common/expected.h>

#include <internal/blackbox/account_info.h>

namespace settings::blackbox {

class BlackBoxInterface {
public:
    virtual ~BlackBoxInterface() {};
    virtual expected<std::string> infoRequest(ContextPtr ctx, const std::string& url) const = 0;
};

class Interface : public yplatform::module {
public:
    virtual expected<void> isUserExists(ContextPtr ctx,
        const std::string& uid, const std::string& userIp) const = 0;
    virtual expected<AccountInfoPtr> getAccountInfo(ContextPtr ctx,
        const std::string& uid, const std::string& userIp) const = 0;
};

} // namespace settings::blackbox
