#pragma once

#include <map>
#include <optional>
#include <string>
#include <vector>

namespace settings::blackbox {

struct Address {
    bool isDefault() const {return def;}
    std::string address;
    std::string date;
    bool native;
    bool validated;
    bool rpop;
    bool def;
};

using AddressList = std::vector<Address>;

struct Uid {
    std::string value;
    std::optional<bool> lite;
    bool hosted;
};

using DbFields = std::map<std::string, std::string>;
using Attributes = std::map<std::string, std::string>;

struct User {
    std::optional<std::string> login;
    std::optional<AddressList> addresses;
    std::optional<Uid> uid;
    std::optional<DbFields> dbfields;
    std::optional<DbFields> attributes;
};

using Users = std::vector<User>;

struct InfoResponse {
    Users users;
};

} // namespace settings::blackbox
