#pragma once

#include <internal/blackbox/types.h>

#include <boost/fusion/adapted.hpp>
#include <yamail/data/reflection/reflection.h>

YREFLECTION_ADAPT_ADT(settings::blackbox::Address,
    YREFLECTION_MEMBER(std::string, address)
    YREFLECTION_MEMBER_RENAMED(std::string, born-date, date)
    YREFLECTION_MEMBER(bool, native)
    YREFLECTION_MEMBER(bool, validated)
    YREFLECTION_MEMBER(bool, rpop)
    YREFLECTION_MEMBER_RENAMED(bool, default, def)
)

YREFLECTION_ADAPT_ADT(settings::blackbox::Uid,
    YREFLECTION_MEMBER(std::string, value)
    YREFLECTION_MEMBER(std::optional<bool>, lite)
    YREFLECTION_MEMBER(bool, hosted)
)

YREFLECTION_ADAPT_ADT(settings::blackbox::User,
    YREFLECTION_MEMBER(std::optional<std::string>, login)
    YREFLECTION_MEMBER_RENAMED(std::optional<settings::blackbox::AddressList>, address-list, addresses)
    YREFLECTION_MEMBER(std::optional<settings::blackbox::Uid>, uid)
    YREFLECTION_MEMBER(std::optional<settings::blackbox::DbFields>, dbfields)
    YREFLECTION_MEMBER(std::optional<settings::blackbox::Attributes>, attributes)
)

YREFLECTION_ADAPT_ADT(settings::blackbox::InfoResponse,
    YREFLECTION_MEMBER(settings::blackbox::Users, users)
)
