#pragma once

#include <macs/settings_repository.h>

#include <boost/asio/spawn.hpp>

#include <yplatform/task_context.h>

#include <internal/common/types.h>

namespace settings {

class context : public yplatform::task_context,
                public boost::noncopyable {
public:
    explicit context(
            const std::string& uniqId,
            const std::string& requestId,
            const std::string& userIp,
            const std::string& clientType,
            const std::string& clientVersion,
            const std::string& testBuckets,
            const std::string& enabledTestBuckets,
            const boost::asio::yield_context& yield
    )
        : yplatform::task_context(uniqId)
        , requestId_(requestId)
        , userIp_(userIp)
        , clientType_(clientType)
        , clientVersion_(clientVersion)
        , testBuckets_(testBuckets)
        , enabledTestBuckets_(enabledTestBuckets)
        , yield_(yield)
    { }


    void uid(const std::string& v) {
        uid_ = v;
    }

    const std::string& uid() const {
        return uid_;
    }

    void userIp(const std::string& value) {
        userIp_ = value;
    }

    const std::string& userIp() const {
        return userIp_;
    }

    void clientType(const std::string& value) {
        clientType_ = value;
    }

    const std::string& clientType() const {
        return clientType_;
    }

    void clientVersion(const std::string& value) {
        clientVersion_ = value;
    }

    const std::string& clientVersion() const {
        return clientVersion_;
    }

    void testBuckets(const std::string& value) {
        testBuckets_ = value;
    }

    const std::string& testBuckets() const {
        return testBuckets_;
    }

    void enabledTestBuckets(const std::string& value) {
        enabledTestBuckets_ = value;
    }

    const std::string& enabledTestBuckets() const {
        return enabledTestBuckets_;
    }

    void requestId(const std::string& value) {
        requestId_ = value;
    }

    const std::string& requestId() const {
        return requestId_;
    }

    void databaseRole(DatabaseRole value) {
        databaseRole_ = value;
    }

    DatabaseRole databaseRole() const {
        return databaseRole_;
    }

    const boost::asio::yield_context& yield() const {
        return yield_;
    }

    void settingsRepository(::macs::SettingsRepositoryPtr repository) {
        repository_ = repository;
    }

    ::macs::SettingsRepositoryPtr settingsRepository() const {
        return repository_;
    }

    void settings(const MapOptionsPtr& value) {
        settings_ = value;
    }

    const MapOptionsPtr settings() const {
        return settings_ ? settings_ : std::make_shared<MapOptions>();
    }

    void settingsList(const SettingsList& value) {
        settingsList_ = value;
    }

    SettingsList settingsList() const {
        return settingsList_;
    }

    void askValidator(bool value) {
        askValidator_ = value;
    }

    bool askValidator() const {
        return askValidator_;
    }


private:
    std::string requestId_;
    std::string uid_;
    std::string userIp_;
    std::string clientType_;
    std::string clientVersion_;
    std::string testBuckets_;
    std::string enabledTestBuckets_;
    DatabaseRole databaseRole_ = DatabaseRole::Master;
    boost::asio::yield_context yield_;
    ::macs::SettingsRepositoryPtr repository_;
    MapOptionsPtr settings_;
    SettingsList settingsList_;
    bool askValidator_ = false;
};

using ContextPtr = boost::shared_ptr<context>;

} // namespace settings
