#pragma once

#include <internal/common/context.h>
#include <internal/common/logger.h>

namespace settings {

inline void logError( const ContextPtr& ctx,
        const std::exception& e) {
    SETTINGS_LOG_ERROR(
        ctx,
        logdog::exception = e
    );
}

inline void logCurrentError( const ContextPtr& ctx,
        const std::exception& e) {
    SETTINGS_LOG_ERROR(
        ctx,
        logdog::exception = e
    );
}

inline void logUnknownError( const ContextPtr& ctx ) {
    SETTINGS_LOG_ERROR(
        ctx,
        logdog::message = "request result is unknown error, no info"
    );
}

inline void logCurrentUnknownError( const ContextPtr& ctx ) {
    SETTINGS_LOG_ERROR(
        ctx,
        logdog::message = "unknown error, no info"
    );
}

inline void logCurrentException( const ContextPtr& ctx ) {
    try {
        throw;
    } catch ( const std::exception& error ) {
        logCurrentError(ctx, error);
    } catch ( ... ) {
        logCurrentUnknownError(ctx);
    }
}

} // namespace settings
