#pragma once

#include <chrono>
#include <pa/async.h>

namespace settings {

class PaLog {
public:
    using Clock = std::chrono::steady_clock;

    PaLog(const yplatform::task_context_ptr& ctx, pa::rem_type t, const std::string& method)
            : uniq_id_{ ctx->uniq_id() },
              type_{ t },
              method_{ method }
    {}
    void operator ()() const {
        using std::chrono::milliseconds;
        using std::chrono::duration_cast;
        const auto duration = duration_cast<milliseconds>(
            Clock::now() - begin_time_).count();
        pa::async_profiler::add(type_, "-", method_, uniq_id_,
            boost::numeric_cast<uint32_t>(duration));
    }

private:
    std::string uniq_id_;
    pa::rem_type type_;
    std::string method_;
    Clock::time_point begin_time_ = Clock::now();
};

} // namespace settings
