#pragma once

#include <pa/async.h>
#include <pgg/profiling.h>


namespace settings::pa {

class PaProfiler: public pgg::profiling::Log {
public:
    virtual void write(const std::string& operation,
            const std::string& info, pgg::Duration duration) const override {
        ::pa::async_profiler::add(::pa::postgresql, "settings",
            operation, info, static_cast<uint32_t>(pgg::Milliseconds{duration}.count()));
    }
};

inline auto create() {
    return boost::make_shared<PaProfiler>();
}

} // namespace settings::pa
