#pragma once

#include <yamail/data/serialization/json_writer.h>

namespace settings::http::detail::format {


template <class T>
class Json {
public:
    Json(const T& value) : value_(value) {}

    template <class Stream>
    Stream& write(Stream& stream) const {
        return yamail::data::serialization::writeJson(stream, value_);
    }

    template <class SetBody>
    void apply(SetBody&& setBody) const {
        setBody(yamail::data::serialization::toJson(value_).str());
    }

private:
    const T& value_;
};

enum class Type {
    Json
};

template <class T>
inline Json<T> json(const T& value) {
    return Json<T>(value);
}

} // namespace format::detail::http::settings
