#pragma once

#include <ymod_webserver/handler.h>

#include <internal/common/expected.h>
#include <internal/common/context.h>
#include <internal/http/detail/request.h>
#include <internal/http/detail/response.h>
#include <internal/http/detail/logic_adaptor.h>
#include <internal/tvm2/tvm_guard.h>


namespace settings::http::detail::handlers {

class Base {
public:
    Base(const std::string& logicModule) : logic_(logicModule) {}

    virtual ~Base() = default;

    virtual std::string uri() const = 0;
    virtual ymod_webserver::methods::http_method method() const = 0;
    void process(RequestPtr request, ResponsePtr response, tvm2::TvmGuardPtr tvmGuardPtr, ContextPtr ctx) const;

protected:
    virtual expected<void> invoke(RequestPtr request, ResponsePtr response, ContextPtr ctx) const = 0;
    const LogicAdaptor& logic() const;
    virtual expected<void> parameters(RequestPtr, ContextPtr) const = 0;

private:
    const LogicAdaptor logic_;
};

} //namespace settings::http::detail::handlers
