#pragma once

#include <internal/http/detail/handlers/base.h>
#include <internal/http/detail/handlers/utils.h>

namespace settings::http::detail::handlers {

class BaseUpdate : public Base {
public:
    BaseUpdate(const std::string& logicModule) : Base(logicModule) {}

    virtual ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

protected:
    virtual expected<void> update(RequestPtr request, ContextPtr ctx) const = 0;

    expected<void> parameters(RequestPtr request, ContextPtr ctx) const override {
        return getUid(ctx, request->url.params)
            .bind(std::bind(getSettings, ctx, request));
    }

private:
    expected<void> invoke(RequestPtr request, ResponsePtr response, ContextPtr ctx) const override;
};

} // namespace settings::detail::http::handlers
