#pragma once

#include <internal/http/detail/handlers/utils.h>
#include <internal/http/detail/handlers/base.h>

namespace settings::http::detail::handlers {

class DeleteParams : public Base {
public:
    DeleteParams(const std::string& logicModule) : Base(logicModule) {}

    std::string uri() const override { return "/delete_params"; }

    virtual ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    expected<void> invoke(RequestPtr request, ResponsePtr response, ContextPtr ctx) const override {
        return deleteParams(request, ctx)
            .bind([&]() {
                response->set_code(ymod_webserver::codes::ok);
                response->set_content_type("text/plain");
                response->result_body("Done");
            });
    }
private:
    expected<void> deleteParams(RequestPtr request, ContextPtr ctx) const {
        return parameters(request, ctx)
            .bind([&]() {
                return logic().deleteParams(ctx);
            });
    }

protected:
    expected<void> parameters(RequestPtr request, ContextPtr ctx) const override {
        return getUid(ctx, request->url.params)
            .bind(std::bind(getSettingsListFromBody, ctx,
                std::string {request->raw_body.begin(), request->raw_body.end()}));
    }
};

} // namespace settings::detail::http::handlers
