#pragma once

#include <internal/http/detail/handlers/base_get.h>
#include <internal/http/detail/handlers/utils.h>

namespace settings::http::detail::handlers {

class GetAllProfile : public BaseGet<Settings, Chunked> {
public:
    GetAllProfile(const std::string& logicModule) : BaseGet(logicModule) {}

    std::string uri() const override { return "/get_all_profile"; }

private:
    expected<MapOptions> get(RequestPtr request, ContextPtr ctx) const override {
        return parameters(request, ctx)
            .bind([&]() {
                return logic().getProfile(ctx);
            });
    }

protected:
    expected<void> parameters(RequestPtr request, ContextPtr ctx) const override {
        return getUid(ctx, request->url.params)
            .bind(std::bind(getAskValidator, ctx, request->url.params))
            .bind(std::bind(getDatabaseRole, ctx, request->url.params));
    }
};

} // namespace settings::detail::http::handlers
