#pragma once

#include <internal/http/detail/handlers/base.h>

namespace settings::http::detail::handlers {

class Ping : public Base {
public:
    Ping(const std::string& logicModule) : Base(logicModule) {}

    std::string uri() const override { return "/ping"; }

    virtual ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_get;
    }

private:
    expected<void> invoke(RequestPtr, ResponsePtr response, ContextPtr) const override {
        response->set_code(ymod_webserver::codes::ok);
        response->set_content_type("text/plain");
        response->result_body("pong");
        return {};
    }

protected:
    expected<void> parameters(RequestPtr, ContextPtr) const override {
        return {};
    }
};

} // namespace settings::http::detail::handlers
