#pragma once

#include <internal/http/detail/handlers/base.h>
#include <internal/http/detail/handlers/utils.h>

namespace settings::http::detail::handlers {

class Remove : public Base {
public:

    Remove(const std::string& logicModule) : Base(logicModule) {}

    std::string uri() const override { return "/remove"; }

    virtual ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    expected<void> invoke(RequestPtr request, ResponsePtr response, ContextPtr ctx) const override {
        return remove(request, ctx)
            .bind([&]() {
                response->set_code(ymod_webserver::codes::ok);
                response->set_content_type("text/plain");
                response->result_body("Done");
            });
    }
private:
    expected<void> remove(RequestPtr request, ContextPtr ctx) const {
        return parameters(request, ctx)
            .bind([&]() {
                return logic().remove(ctx);
            });
    }

protected:
    expected<void> parameters(RequestPtr request, ContextPtr ctx) const override {
        return getUid(ctx, request->url.params);
    }

};

} // namespace settings::detail::http::handlers
