#pragma once

#include <internal/common/context.h>
#include <internal/common/error.h>
#include <internal/common/error_code.h>
#include <internal/common/expected.h>
#include <internal/http/yield_context.h>
#include <internal/http/detail/logic_adaptor.h>
#include <internal/http/detail/response.h>
#include <internal/http/detail/request.h>
#include <internal/http/detail/format.h>

namespace settings::http::detail::handlers {

ContextPtr makeContext(const RequestPtr& request, YieldCtx yc);
ContextId getContextId(const Request& request);
RequestId getRequestId(const Request& request);
UserIp getUserIp(const Request& request);
ClientType getClientType(const Request& request);
ClientVersion getClientVersion(const Request& request);
TestBuckets getTestBuckets(const Request& request);
EnabledTestBuckets getEnabledTestBuckets(const Request& request);
std::string getHeader(const Request& request, const std::string& headerName, const std::string& defaultValue);
std::optional<std::string> getOptionalHeader(const RequestPtr& request, const std::string& headerName);
Uid getUid(const RequestPtr& request);
ymod_webserver::codes::code getYmodWebserverCode(const settings::Error& value);
ymod_webserver::codes::code getYmodWebserverCode(const mail_errors::error_code& value);
expected<format::Type> getFormat(const std::multimap<std::string, std::string>&);
expected<void> getUid(ContextPtr, const std::multimap<std::string, std::string>&);
expected<void> getSettingsListFromParams(ContextPtr, const std::multimap<std::string, std::string>&);
expected<void> getSettingsListFromBody(ContextPtr, const std::string&);
expected<void> getAskValidator(ContextPtr, const std::multimap<std::string, std::string>&);
expected<void> getDatabaseRole(ContextPtr, const std::multimap<std::string, std::string>&);

bool isValidParamName(const std::string&);
bool isValidSettings(const std::string&);
expected<MapOptions> getSettingsFromBody(const std::string&);
expected<MapOptions> getSettingsFromParams(const std::multimap<std::string, std::string>&);
expected<void> getSettings(ContextPtr, const RequestPtr&);




} //namespace settings::http::detail::handlers
