#pragma once

#include <internal/api/api.h>
#include <internal/common/context.h>

namespace settings::http::detail {

using Logic = api::api;

class LogicAdaptor {
public:
    LogicAdaptor(const std::string& module) : module(module) {}

    expected<MapOptions> getProfile(ContextPtr) const;
    expected<MapOptions> getParams(ContextPtr) const;
    expected<DoubleMapOptions> get(ContextPtr) const;

    expected<void> updateProfile(ContextPtr) const;
    expected<void> updateParams(ContextPtr) const;
    expected<void> updateProtectedParams(ContextPtr) const;

    expected<void> remove(ContextPtr) const;
    expected<void> deleteParams(ContextPtr) const;

private:
    const std::string module;

    Logic& impl() const;
};

} // settings::http::detail
