#pragma once

#include <ymod_webserver/response.h>

#include <internal/http/detail/format.h>

namespace settings::http::detail {

using ResponsePtr = ymod_webserver::response_ptr;

template <class Formatted>
class Chunked {
public:
    Chunked(Formatted formatted)
        : formatted(std::move(formatted)) {}

    void operator ()(ymod_webserver::response& response) const {
        response.set_connection(false);
        auto stream = response.result_chunked()->client_stream();
        formatted.write(stream);
    }

private:
    Formatted formatted;
};

template <class Formatted>
class FixedSize {
public:
    FixedSize(Formatted formatted)
        : formatted(std::move(formatted)) {}

    void operator ()(ymod_webserver::response& response) const {
        formatted.apply([&] (const auto& body) { response.result_body(body); });
    }

private:
    Formatted formatted;
};

} // namespace settings::http::detail
