#pragma once

#include <boost/fusion/adapted/struct/define_struct.hpp>

#include <internal/common/types.h>

namespace settings::http::detail {

using Uid = std::string;
using SettingsList = settings::SettingsList;
using DatabaseRole = settings::DatabaseRole;

using Settings = MapOptions;
using SettingsPtr = MapOptionsPtr;
using DoubleSettings = DoubleMapOptions;

using ContextId = std::string;
using RequestId = std::string;
using UserIp = std::string;
using ClientType = std::string;
using ClientVersion = std::string;
using TestBuckets = std::string;
using EnabledTestBuckets = std::string;

} // namespace settings::http::detail

BOOST_FUSION_DEFINE_TPL_STRUCT(
    (Settings), (settings)(http)(detail), ResultSettings,
    (const Settings&, settings))
