#pragma once

#include <yplatform/module.h>

#include <ymod_webserver/server.h>

#include <internal/http/detail/handlers/base.h>
#include <internal/tvm2/tvm_guard.h>

namespace settings::http {

using HandlerPtr = ymod_webserver::handler_ptr;
using HttpServer = ymod_webserver::server;

class Impl : public yplatform::module {
public:
    void init(const yplatform::ptree& config);

private:
    std::string httpServerModule;
    std::string logicModule;
    std::size_t coroutineStackSize;

    template <class Handler>
    void bind(tvm2::TvmGuardPtr tvmGuardPtr);
};

} // namespace settings::http
