#pragma once

#include <internal/macs/config.h>
#include <pgg/service/resolver.h>
#include <yamail/data/reflection/reflection.h>

YREFLECTION_ADAPT_ADT(settings::macs::Config,
    YREFLECTION_WO_MEMBER(std::string, query_conf)
    YREFLECTION_WO_MEMBER(std::string, user)
    YREFLECTION_WO_MEMBER(unsigned, max_connections)
    YREFLECTION_WO_MEMBER(unsigned, queue_timeout_ms)
    YREFLECTION_WO_MEMBER(unsigned, connect_timeout_ms)
    YREFLECTION_WO_MEMBER(unsigned, query_timeout_ms)
)

YREFLECTION_ADAPT_ADT(sharpei::client::http::Address,
    YREFLECTION_WO_MEMBER(std::string, host)
    YREFLECTION_WO_MEMBER(unsigned, port)
)

YREFLECTION_ADAPT_ADT(sharpei::client::Settings,
    YREFLECTION_WO_MEMBER_RENAMED(sharpei::client::http::Address, sharpei_address, sharpeiAddress)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, timeout_ms, sharpei::client::http::Timeout, timeout)
    YREFLECTION_WO_MEMBER(unsigned, retries)
    YREFLECTION_WO_MEMBER_RENAMED(bool, keep_alive, keepAlive)
)

YREFLECTION_ADAPT_ADT(pgg::SharpeiParams,
    YREFLECTION_WO_MEMBER(sharpei::client::Settings, settings)
)

YREFLECTION_ADAPT_ADT(settings::Config,
    YREFLECTION_WO_MEMBER(std::string, mode)
    YREFLECTION_WO_MEMBER(settings::macs::Config, database)
    YREFLECTION_WO_MEMBER(pgg::SharpeiParams, sharpei)
)
