#pragma once

#include <unordered_map>
#include <boost/asio/io_service.hpp>
#include <pgg/database/pool_factory.h>
#include <pgg/chrono.h>
#include <yplatform/reactor.h>
#include <yplatform/find.h>
#include <internal/macs/config.h>
#include <yamail/data/serialization/ptree.h>
using namespace ::pgg;


namespace settings::macs {

class ConnectionPools {
public:
    void create(Config& config) {
        for (const auto& pool : yplatform::global_net_reactor->get_pools()) {
            auto ioc = pool->io();
            pgConnectionPools.emplace(
                std::addressof(*ioc),
                ConnectionPoolFactory()
                    .limit(0)
                    .connectTimeout(Milliseconds(config.connect_timeout_ms))
                    .queueTimeout(Milliseconds(config.queue_timeout_ms))
                    .queryTimeout(Milliseconds(config.query_timeout_ms))
                    .maxConnections(config.max_connections)
                    .ioService(*ioc)
                    .product()
            );
        }
    }

    ConnectionPoolPtr get() {
        return pgConnectionPools.at(yplatform::global_net_reactor->get_pool()->io());
    }

    ~ConnectionPools() {
        pgConnectionPools.clear();
    }

protected:
    std::unordered_map<boost::asio::io_service*, ConnectionPoolPtr> pgConnectionPools;
};

} // namespace settings::macs
