#pragma once

#include <pgg/factory.h>

#include <internal/macs/interface.h>
#include <internal/macs/config.h>
#include <internal/macs/connection_pools.h>

namespace settings::macs {

class Impl: public Interface {
public:
    void init(const yplatform::ptree& config);

    expected<Settings> getSettings(ContextPtr ctx, SettingsList settings) override;
    expected<Profile> getProfile(ContextPtr ctx, SettingsList settings) override;
    expected<Parameters> getParameters(ContextPtr ctx, SettingsList settings) override;

    expected<bool> updateParameters(ContextPtr ctx, ParametersPtr parameters) override;
    expected<bool> updateProtectedParameters(ContextPtr ctx, ParametersPtr parameters) override;
    expected<bool> updateProfile(ContextPtr ctx, ProfilePtr profile) override;
    expected<bool> initSettings(ContextPtr ctx) override;

    expected<bool> deleteSettings(ContextPtr ctx) override;
    expected<bool> eraseParameters(ContextPtr ctx, SettingsList settings) override;

private:
    decltype(auto) repository(ContextPtr ctx);

    settings::Config config;
    pgg::QueryConf queryConf;
    ConnectionPools сonnectionPools;
    Mode mode;
};

} // namespace settings::macs
