#pragma once

#include <yplatform/module.h>

#include <internal/common/context.h>
#include <internal/common/expected.h>
#include <internal/common/types.h>

using ContextPtr = settings::ContextPtr;

namespace settings::macs {

class Interface: public yplatform::module {
public:
    virtual expected<Settings> getSettings(ContextPtr ctx, SettingsList settings) = 0;
    virtual expected<Profile> getProfile(ContextPtr ctx, SettingsList settings) = 0;
    virtual expected<Parameters> getParameters(ContextPtr ctx, SettingsList settings) = 0;
    virtual expected<bool> updateParameters(ContextPtr ctx, ParametersPtr parameters) = 0;
    virtual expected<bool> updateProtectedParameters(ContextPtr ctx, ParametersPtr parameters) = 0;
    virtual expected<bool> updateProfile(ContextPtr ctx, ProfilePtr profile) = 0;
    virtual expected<bool> initSettings(ContextPtr ctx) = 0;
    virtual expected<bool> deleteSettings(ContextPtr ctx) = 0;
    virtual expected<bool> eraseParameters(ContextPtr ctx, SettingsList settings) = 0;
};

} //namespace settings::macs
