#pragma once

#include <sharpei_client/http.h>
#include <ymod_httpclient/call.h>
#include <butil/http/arguments.h>
#include <butil/http/headers.h>

namespace settings::sharpei {

using namespace ::sharpei::client::http;

class SharpeiHttpClient: public HttpClient {
public:
    SharpeiHttpClient(std::shared_ptr<yhttp::call> httpClient,
        yplatform::time_traits::duration connectTimeout)
        : connectTimeout_(connectTimeout),
          httpClient_(std::move(httpClient)) {
    }

    void aget(const Address& addr, Timeout timeout, const std::string& method,
            const Arguments& args, const Headers& headers, ResponseHandler handler,
            bool keepAlive, const std::string& requestId) const override {
        yhttp::options options;
        options.reuse_connection = keepAlive;
        options.timeouts.connect = connectTimeout_;
        options.timeouts.total = timeout;

        httpClient_->async_run(
            boost::make_shared<yplatform::task_context>(requestId),
            yhttp::request::GET(
                addr.host + ":" + std::to_string(addr.port) + method + "?"
                    + HttpArguments {args}.format(),
                http::headers {headers}.format()
            ),
            options,
            [h = std::move(handler)](
                boost::system::error_code error,
                yhttp::response resp
            ) {
                h(error, Response{static_cast<unsigned>(resp.status), std::move(resp.body)});
            }
        );
    }

    void apost(const Address&, Timeout, const std::string&,
            const Arguments&, const Headers&, const std::string&,
            ResponseHandler, bool, const std::string&) const override {
        throw std::logic_error("SharpeiHttpClient::apost is not implemented");
    }

private:
    yplatform::time_traits::duration connectTimeout_;
    std::shared_ptr<class yhttp::call> httpClient_;

};

} // namespace settings::sharpei
