#pragma once

#include <string>
#include <internal/recognizer/interface.h>

#include "wrapper.h"
#include "charset_traits.h"

namespace settings::utfizer {

class UTFizer : public Interface {
public:

    std::string utfize(const std::string& text) const override;
    std::pair<std::int32_t, std::int32_t> recognize(const std::string& text) const override;

    UTFizer() : recognizer(Recognizer::instance()) {}
    UTFizer(const TWebmailRecognizer& recognizer) : recognizer(recognizer) {}
private:
    bool untrustedCharset( const std::string & charset ) const;
    std::string convert(Recognizer::CodesEnum code, const std::string & text) const;
    std::string convert(const std::string & charset, const std::string & text) const;
    std::string convert(const CharsetTraitsMap::CharsetTraits & traits, const std::string & text) const;
    Recognizer::CodesEnum recognizeEncoding(const std::string& text) const;
    static const CharsetTraitsMap map;

    const TWebmailRecognizer& recognizer;
};

} // namespace settings::utfizer
