#pragma once

#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>


namespace settings::tvm2 {

template <class Config, class Module>
auto makeTvmGuard(const Config& config, std::shared_ptr<Module> modulePtr) {
    return std::make_shared<tvm_guard::Guard<Module>>(
        tvm_guard::init(config, modulePtr)
    );
}

using TvmModule = ymod_tvm::tvm2_module;
using TvmGuardPtr = std::shared_ptr<tvm_guard::Guard<TvmModule>>;

} //namespace settings::tvm2
