#pragma once

#include <user_journal/service.h>

#include <internal/blackbox/interface.h>

#include <internal/user_journal/interface.h>
#include <internal/user_journal/tskv_writer.h>

namespace settings::user_journal {

using Blackbox = blackbox::Interface;

class Impl : public Interface {
public:
    void init(const yplatform::ptree& config);
    void reload(const yplatform::ptree& config);

    void asyncLogSettingsUpdate(ContextPtr ctx, MapOptions value) override;
    void asyncLogSettingsUpdate(ContextPtr ctx, SettingsMap value) override;
    void asyncLogSettingsUpdate(ContextPtr ctx, SignaturesList value) override;

private:
    struct Setting {
        std::string name;
        std::string value;

        Setting(std::string&& name, std::string&& value)
            : name(std::move(name)), value(std::move(value)) {}

        Setting(SettingsMap::value_type&& value)
            : name(std::move(value.first)), value(std::move(value.second)) {}
    };

    struct SettingsVector : std::vector<Setting> {
        using Base = std::vector<Setting>;

        SettingsVector(MapOptions&& value);

        SettingsVector(SettingsMap&& value)
            : Base(std::make_move_iterator(value.begin()),
                   std::make_move_iterator(value.end())) {}

        SettingsVector(const SignaturesList& value);
    };

    using Mutex = boost::shared_mutex;
    using SharedLock = boost::shared_lock<Mutex>;
    using UniqueLock = boost::unique_lock<Mutex>;

    mutable Mutex mutex;
    ::user_journal::ServicePtr service;
    std::shared_ptr<TskvWriter> tskvWriter;

    template <class T>
    void asyncLogSettingsUpdateImpl(ContextPtr ctx, T&& value);
    void logSettingsUpdate(ContextPtr ctx, const std::string& uid, const SettingsVector& value);
    void logOneSettingUpdate(ContextPtr ctx, const std::string& uid, const Setting& value);
    Blackbox& blackbox() const;
    static std::string reflect(const SignaturesList& value);
};

} // namespace settings::user_journal
