#pragma once

#include <user_journal/logging.h>

namespace settings::user_journal {

class Log : public ::user_journal::logging::Log {
public:
    void error(const std::string& uid, const std::string& method,
               const std::string& message, int code) override;

    void warning(const std::string& uid, const std::string& method,
                 const std::string& message, int code) override;

    void notice(const std::string& uid, const std::string& method,
                const std::string& message) override;

    void debug(const std::string& uid, const std::string& method,
               const std::string& message) override;
};

} // namespace settings::user_journal
