#pragma once

#include <fstream>
#include <iostream>
#include <mutex>

#include <boost/noncopyable.hpp>

#include <user_journal/file_writer.h>

namespace settings::user_journal {

class TskvWriter : public std::enable_shared_from_this<TskvWriter>,
                   boost::noncopyable {
public:
    class Interface {
    public:
        Interface(const std::shared_ptr<TskvWriter>& impl) : impl(impl) {}

        void operator ()(const std::string& value) const {
            impl->write(value);
        }

    private:
        std::shared_ptr<TskvWriter> impl;
    };

    TskvWriter(const std::string& fileName)
            : stream(fileName.c_str(), openMode) {}

    Interface interface() {
        return Interface(shared_from_this());
    }

    void write(const std::string& value) {
        const Lock lock(mutex);
        stream << value << std::flush;
    }

private:
    using Mutex = std::mutex;
    using Lock = std::lock_guard<Mutex>;
    using OpenMode = std::ios_base::openmode;

    static constexpr OpenMode openMode = std::ofstream::out | std::ofstream::app;

    std::ofstream stream;
    Mutex mutex;
};

} // namespace settings::user_journal

