#include <internal/api/utils.h>

#include <boost/range/algorithm.hpp>
#include <boost/range/adaptor/transformed.hpp>

namespace settings::api {

bool hasSetting(const SettingsList& settings, const std::string& name) {
    return settings.empty() || boost::range::find(settings, name) != settings.end();
}

void addDefaultEmail(MapOptions& options, AccountInfoPtr accountInfo, const SettingsList& settings) {
    const std::string defaultEmailSettings = "default_email";
    if (hasSetting(settings, defaultEmailSettings)) {
        if (accountInfo) {
            auto& defaultEmail = options.single_settings[defaultEmailSettings];
            if (!accountInfo->validateDefaultEmail(defaultEmail)) {
                defaultEmail = accountInfo->emails().defaultEmail->address;
            }
        } else {
            options.single_settings.erase(defaultEmailSettings);
        }
    }
}

void addFromName(MapOptions& options, AccountInfoPtr accountInfo, const SettingsList& settings, std::string mode) {
    const std::string fromName = "from_name";
    if (hasSetting(settings, fromName)
            && options.single_settings.find(fromName) == options.single_settings.end()) {
        if (accountInfo) {
            if (mode == "corp" && !accountInfo->fromNameEng().empty()) {
                options.single_settings[fromName] = accountInfo->fromNameEng();
            } else {
                options.single_settings[fromName] = accountInfo->fromName();
            }
        } else {
            options.single_settings[fromName] = "";
        }
    }
}

void addEmails(MapOptions& options, AccountInfoPtr accountInfo, const SettingsList& settings) {
    if (hasSetting(settings, "emails") && accountInfo) {
        options.emails = accountInfo->emails().items;
    }
}

void getMacsSignatures(
    const SignaturesListOpt& signs,
    MacsSignaturesListOpt& macsSigns
) {
    if (signs) {
        macsSigns = settings::MacsSignaturesList {};
        macsSigns->reserve(signs->size());
        boost::range::copy(
            *signs | boost::adaptors::transformed([] (auto& sign) {return MacsSignature {sign};}),
            std::back_inserter(*macsSigns)
        );
    }
}

}
