#include <internal/http/detail/handlers/base_update.h>

namespace settings::http::detail::handlers {

expected<void> BaseUpdate::invoke(RequestPtr request, ResponsePtr response, ContextPtr ctx) const {
    return update(request, ctx)
        .bind([&]() {
            response->set_code(ymod_webserver::codes::ok);
            response->set_content_type("text/plain");
            response->result_body("Done");
        });
}

} // namespace settings::detail::http::handlers
