#include <yplatform/find.h>

#include <internal/http/detail/logic_adaptor.h>

namespace settings::http::detail {

expected<void> LogicAdaptor::remove(ContextPtr ctx) const {
    return impl().remove(ctx);
}

expected<DoubleMapOptions> LogicAdaptor::get(ContextPtr ctx) const {
    return impl().get(ctx);
}

expected<MapOptions> LogicAdaptor::getParams(ContextPtr ctx) const {
    return impl().getParams(ctx);
}

expected<MapOptions> LogicAdaptor::getProfile(ContextPtr ctx) const {
    return impl().getProfile(ctx);
}

expected<void> LogicAdaptor::updateProfile(ContextPtr ctx) const {
    return impl().updateProfile(ctx);
}

expected<void> LogicAdaptor::updateParams(ContextPtr ctx) const {
    return impl().updateParams(ctx);
}

expected<void> LogicAdaptor::updateProtectedParams(ContextPtr ctx) const {
    return impl().updateProtectedParams(ctx);
}

expected<void> LogicAdaptor::deleteParams(ContextPtr ctx) const {
    return impl().deleteParams(ctx);
}

Logic& LogicAdaptor::impl() const {
    return *yplatform::find<Logic, std::shared_ptr>(module);
}

} // settings::http::detail
