#include <yplatform/find.h>

#include <internal/http/impl.h>
#include <internal/http/yield_context.h>

#include <internal/http/detail/handlers/base.h>
#include <internal/http/detail/handlers/base_get.h>
#include <internal/http/detail/handlers/base_update.h>
#include <internal/http/detail/handlers/get.h>
#include <internal/http/detail/handlers/get_all.h>
#include <internal/http/detail/handlers/get_all_params.h>
#include <internal/http/detail/handlers/get_all_profile.h>
#include <internal/http/detail/handlers/get_params.h>
#include <internal/http/detail/handlers/get_profile.h>
#include <internal/http/detail/handlers/ping.h>
#include <internal/http/detail/handlers/update_params.h>
#include <internal/http/detail/handlers/update_protected_params.h>
#include <internal/http/detail/handlers/update_profile.h>
#include <internal/http/detail/handlers/remove.h>
#include <internal/http/detail/handlers/delete_params.h>
#include <internal/http/detail/handlers/utils.h>


namespace settings::http {

void Impl::init(const yplatform::ptree& config) {
    httpServerModule = config.get<std::string>("http_server_module");
    logicModule = config.get<std::string>("logic_module");
    coroutineStackSize = config.get<std::size_t>("coroutine_stack_size", 1048576);
    auto tvmGuardPtr = tvm2::makeTvmGuard(
        config.get_child("tvm_guard"),
        yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>("ymod_tvm")
    );

    using namespace detail::handlers;
    bind<Get>(tvmGuardPtr);
    bind<GetAll>(tvmGuardPtr);
    bind<GetAllParams>(tvmGuardPtr);
    bind<GetAllProfile>(tvmGuardPtr);
    bind<GetParams>(tvmGuardPtr);
    bind<GetProfile>(tvmGuardPtr);
    bind<Ping>(tvmGuardPtr);
    bind<UpdateParams>(tvmGuardPtr);
    bind<UpdateProtectedParams>(tvmGuardPtr);
    bind<UpdateProfile>(tvmGuardPtr);
    bind<Remove>(tvmGuardPtr);
    bind<DeleteParams>(tvmGuardPtr);
}

template <class Handler>
void Impl::bind(tvm2::TvmGuardPtr tvmGuardPtr) {
    const auto handler = std::make_shared<Handler>(logicModule);
    const auto httpServer = yplatform::find<HttpServer, std::shared_ptr>(httpServerModule);
    httpServer->bind("", {handler->uri()}, [=] (detail::ResponsePtr stream) {
        spawn([handler = std::move(handler), tvmGuardPtr = std::move(tvmGuardPtr), stream = std::move(stream)] (YieldCtx yc) {
            handler->process(stream->request(), stream, tvmGuardPtr, detail::handlers::makeContext(stream->request(), yc));
        }, coroutineStackSize);
    });
}

} //namespace settings::http

#include <yplatform/module_registration.h>

DEFINE_SERVICE_OBJECT(settings::http::Impl)
