#include <pa/async.h>

#include <internal/pa/impl.h>

namespace settings::pa {

void Impl::init(const yplatform::ptree& config) {
    file = config.get<std::string>("file");
}

void Impl::reload(const yplatform::ptree& config) {
    init(config);
}

void Impl::start() {
    ::pa::async_profiler::init(1000000, 16000, file);
}

} // namespace settings::pa

#include <yplatform/module_registration.h>

DEFINE_SERVICE_OBJECT(settings::pa::Impl)
