#include <yplatform/log.h>

#include <internal/user_journal/log.h>

namespace settings::user_journal {

void Log::error(const std::string & uid, const std::string & method,
        const std::string & message, int code) {
    YLOG_GLOBAL(error) << "user_journal status=error uid=" << uid << " code=" << code
              << " reason=[" << method << ": " << message << "]";
}

void Log::warning(const std::string & uid, const std::string & method,
        const std::string & message, int code) {
    YLOG_GLOBAL(warning) << "user_journal status=warning uid=" << uid << " code=" << code
                << " reason=[" << method << ": " << message << "]";
}

void Log::notice(const std::string & uid, const std::string & method,
        const std::string & message) {
    YLOG_GLOBAL(info) << "user_journal status=notice uid=" << uid
             << " reason=[" << method << ": " << message << "]";
}

void Log::debug(const std::string & uid, const std::string & method,
        const std::string & message) {
    YLOG_GLOBAL(debug) << "user_journal status=debug uid=" << uid
              << " reason=[" << method << ": " << message << "]";
}

} // namespace settings::user_journal
