from cpython cimport *

from libcpp.vector cimport vector
from libcpp.utility cimport move

from mail.unistat.cpp.cython.run_cpp cimport run as run_cpp
from mail.unistat.cpp.cython.logs cimport *


cdef extern from "mail/settings/unistat/cpp/logs.h" namespace "unistat":	
    cdef cppclass Logs:	
        Logs(...)


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[Logs] cppLogs
    cppLogs.reserve(len(pyLogs))
    for l in pyLogs:
        if isinstance(l, AccessTskv):
            cppLogs.push_back(
                Logs((<AccessTskv>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                Logs((<HttpClientLog>l).__impl)
            )
        elif isinstance(l, PaLog):
            cppLogs.push_back(
                Logs((<PaLog>l).__impl)
            )
        elif isinstance(l, SupervisorLog):
            cppLogs.push_back(
                Logs((<SupervisorLog>l).__impl)
            )
        elif isinstance(l, TskvLog):
            cppLogs.push_back(
                Logs((<TskvLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")

    run_cpp(move(host), move(port), move(cppLogs), move(yplatformLogPath), move(logLevel))
