#include <cerrno>
#include <cstring>
#include <ctime>
#include <sstream>
#include <stdexcept>

#include "cache.h"
#include <spdlog/details/format.h>

extern "C" struct tm *__real_localtime_r(const time_t *, struct tm *);
extern "C" struct tm *__real_gmtime_r(const time_t *, struct tm *);

namespace sharpei {

using GetTime = std::tm *(*)(const std::time_t *, std::tm *);

static std::tm getTmValue(GetTime getTime) {
    const auto time = std::time(nullptr);
    std::tm result;
    if (!getTime(&time, &result)) {
        throw std::runtime_error(fmt::format("Get time in sharpei::getTmValue failed: {}", std::strerror(errno)));
    }
    return result;
}

} // namespace sharpei

void getCachedLocalTime(std::tm *value) {
    static std::tm cache = sharpei::getTmValue(__real_localtime_r);
    *value = cache;
}

void getCachedGmTime(std::tm *value) {
    static std::tm cache = sharpei::getTmValue(__real_gmtime_r);
    *value = cache;
}
