#include <time.h>

#include "offtime.h"
#include "cache.h"

struct tm *__wrap_localtime_r(const time_t *timep, struct tm *result) {
    getCachedLocalTime(result);
    return __offtime(timep, result->tm_gmtoff, result) ? result : 0;
}

struct tm *__wrap_gmtime_r(const time_t *timep, struct tm *result) {
    getCachedGmTime(result);
    return __offtime(timep, result->tm_gmtoff, result) ? result : 0;
}
