#!/bin/bash

logs=(
/var/log/statbox/watcher-*.log
)

# Rotate old logs
for log in ${logs[@]} ; do
    for i in $(seq 12 -1 0); do
        [ -f $log.$i ] && mv -f $log.$i $log.`expr $i + 1`
    done
done

# Rotate actual log
for log in ${logs[@]} ; do
    [ -f $log ] && mv $log $log.0
done

# Reload services, when logs rotated
/etc/init.d/statbox-push-client reload > /dev/null
