#!/bin/bash

logs=(
/var/log/sharpei/access.log
/var/log/sharpei/yplatform.log
/var/log/sharpei/sharpei.log
/var/log/sharpei/user_journal.tskv
/var/log/sharpei/profiler.log
/var/log/sharpei/status.log
/var/log/sharpei/http_client.log
)

KEEP_LOGS=6

# Rotate old logs
for log in ${logs[@]} ; do
    for i in $(seq ${KEEP_LOGS} -1 0); do
        [ -f $log.$i ] && mv -f $log.$i $log.`expr $i + 1`
        [ -f ${log}.${i}.gz ] && mv -f ${log}.${i}.gz ${log}.`expr $i + 1`.gz
    done
done

# Rotate actual log
for log in ${logs[@]} ; do
    [ -f $log ] && mv $log $log.0
done

# Reload services, when logs rotated
[ -x /etc/init.d/sharpei ] && /etc/init.d/sharpei reload > /dev/null
[ -e /etc/init/sharpei.conf ] && reload sharpei > /dev/null

# Compress logs
for log in ${logs[@]} ; do
    for i in $(seq ${KEEP_LOGS} -1 0); do
        [ -f $log.$i ] && gzip $log.$i
    done
done

