#!/usr/bin/env python3

from subprocess import Popen, PIPE, DEVNULL


def main():
    curl = Popen(['curl', '--silent', '--verbose', '--max-time', '1',
                  '--user-agent', 'wd-sharpei-ping', 'http://localhost:9999/ping'], stdout=PIPE, stderr=PIPE)
    curl.wait(1)
    out = curl.stdout.read().decode('utf-8')
    if out == 'pong':
        return
    err = curl.stderr.read().decode('utf-8')
    message = 'no pong from sharpei: stdout=[%s] stderr=[%s]' % (out.replace('\n', '\\n'), err.replace('\n', '\\n'))
    Popen(['logger', '--priority', 'daemon.err', message], stdout=DEVNULL, stderr=DEVNULL).wait(1)
    Popen(['initctl', 'restart', 'sharpei'], stdout=DEVNULL, stderr=DEVNULL).wait(1)

if __name__ == '__main__':
    main()
