#!/bin/sh
# Restarts sharpei on (virtual) memory exceed

RSS_LIMIT=4000000
VMSIZE=`cat /proc/meminfo  | head -1 | awk '{print $2}'`
RATIO=`sysctl vm.overcommit_ratio | awk '{print $3}'`
SWAP=`cat /proc/meminfo | grep SwapTotal | awk '{print $2}'`
VMSIZE_LIMIT=`echo "scale=1;(${VMSIZE}+${SWAP})*(${RATIO}/100)+1000000" | bc -l | sed 's/\.[0-9]$//'`

PID=`pidof /usr/bin/sharpei 2>/dev/null`

if [ "$PID" != "" ] ; then
    if [ -f /proc/$PID/status ] ; then
        RSS_USED=`grep VmRSS /proc/$PID/status | awk '{print $2}'`

        if [ $RSS_USED -ge $RSS_LIMIT ]; then
            service sharpei restart >/dev/null 2>&1
            logger -p daemon.err "sharpei restarted due to memory feeding ($RSS_USED kB)";
            exit 0
        fi

        VMEM_USED=`grep VmSize /proc/$PID/status | awk '{print $2}'`
        if [ $VMEM_USED -ge $VMSIZE_LIMIT ]; then
            service sharpei restart >/dev/null 2>&1
            logger -p daemon.err "sharpei restarted due to virtual memory feeding ($VMEM_USED kB)";
            exit 0
        fi
    fi
fi
