#!/usr/bin/env python2

import json
import jwt
import sys
import time
import os
import traceback


def main():
    try:
        output = sys.argv[1]
        data = json.load(sys.stdin)
        private_key = data['private_key']
        key_id = data['id']
        service_account_id = data['service_account_id']
        now = int(time.time())
        payload = {
            'aud': 'https://iam.api.cloud.yandex.net/iam/v1/tokens',
            'iss': service_account_id,
            'iat': now - 120,
            'exp': now + 3600 - 120,
        }
        encoded_token = jwt.encode(
            payload,
            private_key,
            algorithm='PS256',
            headers=dict(kid=key_id),
        )
        temp = output + '.tmp'
        with open(temp, 'w') as stream:
            stream.write(encoded_token)
        os.rename(temp, output)
    except:
        traceback.print_exc()
        exit(-1)


if __name__ == '__main__':
    main()
