#pragma once

#include <io_result/io_result.h>

namespace sharpei {

template <class Value, class Handler>
class SplitHandlersAsyncOperation {
public:
    SplitHandlersAsyncOperation(Handler handler) : handler(std::move(handler)) {}

    template <class Impl>
    void perform(Impl&& impl) {
        std::forward<Impl>(impl)(*this, *this);
    }

    void operator ()(Value value) {
        boost::asio::dispatch(io_result::bind(handler, mail_errors::error_code(), std::move(value)));
    }

    void operator ()(mail_errors::error_code ec) {
        boost::asio::dispatch(io_result::bind(handler, std::move(ec), Value {}));
    }

private:
    Handler handler;
};

template <class Handler>
class SplitHandlersAsyncOperation<void, Handler> {
public:
    SplitHandlersAsyncOperation(Handler handler) : handler(std::move(handler)) {}

    template <class Impl>
    void perform(Impl&& impl) {
        std::forward<Impl>(impl)(*this, *this);
    }

    void operator ()() {
        boost::asio::dispatch(io_result::bind(handler, mail_errors::error_code()));
    }

    void operator ()(mail_errors::error_code ec) {
        boost::asio::dispatch(io_result::bind(handler, std::move(ec)));
    }

private:
    Handler handler;
};

template <class Value, class Handler>
class SingleHandlerAsyncOperation {
public:
    SingleHandlerAsyncOperation(Handler handler) : handler(std::move(handler)) {}

    template <class Impl>
    void perform(Impl&& impl) {
        std::forward<Impl>(impl)(*this);
    }

    void operator ()(mail_errors::error_code ec, Value value) {
        boost::asio::dispatch(io_result::bind(handler, std::move(ec), std::move(value)));
    }

private:
    Handler handler;
};

template <class Value, template <class, class> class AsyncOperation, class CompletionToken, class Perform>
auto performAsyncOperation(CompletionToken&& token, Perform&& perform) {
    io_result::detail::init_async_result<CompletionToken, io_result::Hook<Value>> init(token);
    AsyncOperation<Value, std::decay_t<decltype(init.handler)>>(init.handler).perform(std::forward<Perform>(perform));
    return init.result.get();
}

template <class Value, template <class, class> class AsyncOperation, class Perform>
auto performAsyncOperation(boost::asio::yield_context yield, Perform&& perform) {
    return performAsyncOperation<Value, AsyncOperation>(
        io_result::make_yield_context(yield),
        std::forward<Perform>(perform)
    );
}

} // namespace sharpei
