#ifndef SHARPEI_ASYNC_PROFILE_H
#define SHARPEI_ASYNC_PROFILE_H

#include <internal/logger.h>

namespace sharpei {

template <class Handler>
class AsyncProfile {
    using HandlerT = std::decay_t<Handler>;

public:
    AsyncProfile(Profile&& profile, Handler&& handler)
        : profile(std::move(profile)),
          handler(std::forward<Handler>(handler)) {}

    template <class ... Args>
    void operator ()(Args&& ... args) const {
        profile();
        handler(std::forward<Args>(args) ...);
    }

private:
    Profile profile;
    HandlerT handler;
};

template <class Handler>
AsyncProfile<Handler> asyncProfile(Profile&& profile, Handler&& handler) {
    return AsyncProfile<Handler>(std::move(profile), std::forward<Handler>(handler));
}

} // namespace sharpei

#endif // SHARPEI_ASYNC_PROFILE_H
