#pragma once

#include <internal/cache/role.h>
#include <internal/cache/status.h>
#include <internal/cache/state.h>
#include <internal/cache/shard_name.h>
#include <internal/errors.h>

#include <yamail/expected.h>

#include <memory>
#include <optional>

namespace sharpei {
namespace cache {

struct Cache {
    using OptShardMaster = boost::optional<Shard::Database::Address>;

    RoleCache role;
    StatusCache status;
    StateCache state;
    ShardNameCache shardName;

    Cache(std::size_t historyCapacity, std::size_t errorsLimit)
            : status(historyCapacity, errorsLimit) {}

    Cache(std::size_t historyCapacity, std::size_t errorsLimit, const Cache& other);

    OptShardMaster getAliveShardMaster(Shard::Id shardId) const;
    std::pair<ExplainedError, boost::optional<Shard>> getShard(Shard::Id shardId) const;
};

using CachePtr = std::shared_ptr<cache::Cache>;

yamail::expected<RoleCache::Shards> selectShards(const Cache& cache, std::optional<Shard::Id> shardId);
ShardsInfoOldFormat makeShardsInfoOldFormat(const Cache& cache, Availability::GetMethod availability);
ShardsInfoNewFormat makeShardsInfoNewFormat(const RoleCache::Shards& shards, const Cache& cache,
                                            Availability::GetMethod availability);
Shard::Databases makeShardDatabases(Shard::Id shardId, const RoleCache::Hosts& hosts,
                                    Availability::GetMethod availability, const Cache& cache);

} // namespace cache
} // namespace sharpei
