#pragma once

#include <unordered_map>
#include <boost/optional.hpp>
#include <internal/shard.h>
#include <internal/guarded.h>

namespace sharpei {
namespace cache {

class RoleCache {
public:
    using Role = Shard::Database::Role;
    using OptRole = boost::optional<Role>;
    using Address = Shard::Database::Address;
    using HostsWithOptRole = std::map<Address, OptRole>;
    using Hosts = std::map<Address, Role>;
    using HostsSet = std::vector<Address>;
    using Shards = std::unordered_map<Shard::Id, Hosts>;

    RoleCache& operator =(const RoleCache& other);

    OptRole getRole(Shard::Id shardId, const Address& address) const;
    Hosts get(Shard::Id shardId) const;
    HostsSet get(Shard::Id shardId, Role role) const;
    void update(Shard::Id shardId, const HostsWithOptRole& hosts);
    void erase(Shard::Id shardId);
    Shards all() const;

private:
    using AddrAndRole = const Hosts::value_type&;
    using AddrAndOptRole = const HostsWithOptRole::value_type&;

    guarded<Shards, std::shared_mutex> shards;

    static void updateOldMasters(Hosts& oldHosts, const HostsWithOptRole& updatedHosts);
    static RoleCache::Hosts makeNewHosts(const Hosts& oldHosts, const HostsWithOptRole& updatedHosts);
};

} // namespace cache
} // namespace sharpei
