#pragma once

#include <unordered_map>
#include <boost/optional.hpp>
#include <internal/shard.h>
#include <internal/guarded.h>

namespace sharpei {
namespace cache {

class ShardNameCache {
public:
    using Shards = std::unordered_map<Shard::Id, Shard::Name>;
    using OptShardName = boost::optional<Shard::Name>;

    OptShardName get(Shard::Id shardId) const;
    void update(Shard::Id shardId, Shard::Name name);
    void erase(Shard::Id shardId);
    Shards all() const;

private:
    guarded<Shards, std::shared_mutex> shards;
};

} // namespace cache
} // namespace sharpei
